/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.trident.VWIDMTridentItem;
import java.awt.Container;

public class VWIDMTridentDialog
implements IVWIDMDialog {
    WcmDlg dlg;
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private static final String m_className = "VWIDMTridentDialog";

    public VWIDMTridentDialog(WcmDlg dlg) {
        this.dlg = dlg;
    }

    public int getMode() {
        return this.mapSelectedMode(this.dlg.getSelectedMode());
    }

    public IVWIDMItem getSelectedItem() {
        WcmDlgItem item = this.dlg.getSelectedItem();
        return VWIDMTridentItem.fromWcmDlgItem(item);
    }

    public void setTitle(String title) {
        this.dlg.setTitle(title);
    }

    public void setButtonText(String buttonText) {
    }

    public int showDialog(Container parent) throws VWException {
        String m_method = "showDialog";
        try {
            logger.entering(m_className, m_method);
            int res = this.mapDlgResult(this.dlg.showDialog(parent));
            logger.exiting(m_className, m_method, new Integer(res));
            return res;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.VWIDMTridentDialog.showDialog", "Exception: {0}", e.getMessage());
        }
    }

    public void setFilename(String fileName) throws VWException {
        String m_method = "setFilename";
        try {
            if (fileName == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Don't want Null filename");
                }
                throw new VWException("idm.trident.VWIDMTridentDialog.setFilename.nullFileName", "Workflow name is null.");
            }
            this.dlg.setFilename(fileName);
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw new VWException("idm.trident.VWIDMTridentDialog.setFilename", "Exception: {0}", e.getMessage());
        }
    }

    private int mapDlgResult(int dlgResult) {
        return dlgResult;
    }

    private int mapSelectedMode(int dlgMode) {
        logger.fine(m_className, "mapSelectedMode", Integer.toString(dlgMode));
        return dlgMode;
    }

    public void setButtonMnemonic(String buttonMnemonic) {
        this.dlg.setButtonMnemonic(buttonMnemonic);
    }

    public void setButtonTooltip(String buttonToolTip) {
        this.dlg.setButtonTooltip(buttonToolTip);
    }
}

